<?php
session_start();
include 'db.php'; // mysqli connection $conn

// --- Admin login ---
$login_error = '';
if (isset($_POST['admin_user'], $_POST['admin_pass'])) {
    $user = trim($_POST['admin_user']);
    $pass = trim($_POST['admin_pass']);
    if ($user === 'admin' && $pass === 'admin123') {
        $_SESSION['admin'] = true;
    } else {
        $login_error = "Invalid username or password.";
    }
}

// --- AJAX toggle seller_active ---
if (isset($_GET['ajax_toggle']) && is_numeric($_GET['ajax_toggle']) && isset($_SESSION['admin'])) {
    $id = (int)$_GET['ajax_toggle'];
    $stmt = $conn->prepare("SELECT seller_active FROM registration WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $row = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    $new_status = $row['seller_active'] ? 0 : 1;
    $stmt = $conn->prepare("UPDATE registration SET seller_active=? WHERE id=?");
    $stmt->bind_param("ii", $new_status, $id);
    $stmt->execute();
    $stmt->close();

    echo $new_status;
    exit;
}

// --- Handle edit submission ---
if (isset($_POST['edit_id'], $_SESSION['admin'])) {
    $id = (int)$_POST['edit_id'];
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $is_seller = isset($_POST['is_seller']) ? 1 : 0;
    $expiry = $_POST['seller_expiry'] ?: null;
    $password = $_POST['seller_password'] ?: null;

    if ($password) {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
    } else {
        $password_hash = null;
    }

    $stmt = $conn->prepare("UPDATE registration SET name=?, phone=?, is_seller=?, seller_expiry=?, seller_password=? WHERE id=?");
    $stmt->bind_param("ssissi", $name, $phone, $is_seller, $expiry, $password_hash, $id);
    $stmt->execute();
    $stmt->close();

    header("Location: admlogin.php?type=" . ($_GET['type'] ?? 'all'));
    exit;
}

// --- Fetch registrations ---
$type_filter = $_GET['type'] ?? 'all';
$where = '';
if ($type_filter === 'seller') $where = "WHERE is_seller=1";
elseif ($type_filter === 'viewer') $where = "WHERE is_seller=0";

$rows = false;
if (isset($_SESSION['admin'])) {
    $rows = $conn->query("SELECT * FROM registration $where ORDER BY id DESC");
    if (!$rows) die("Database query failed: " . $conn->error);
}

// --- Delete expired products ---
if (isset($_POST['delete_expired'], $_SESSION['admin'])) {
    $res = $conn->query("SELECT id, image_url FROM products WHERE status=0");
    while ($p = $res->fetch_assoc()) {
        $file = __DIR__ . '/uploads/' . ltrim($p['image_url'], '/');
        if (file_exists($file)) unlink($file);
        $stmt = $conn->prepare("DELETE FROM products WHERE id=?");
        $stmt->bind_param("i", $p['id']);
        $stmt->execute();
        $stmt->close();
    }
    $success_msg = "All expired products deleted successfully.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Panel</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f8f9fa; }
.card-login { max-width:400px; margin:auto; margin-top:50px; }
.filter-links a { margin-right:10px; }
.table-responsive { overflow-x:auto; }
.summary-row td { cursor:pointer; }
.details-row { background:#f1f3f5; }
.btn-block { width:100%; margin-top:3px; }
.card-equal { display:flex; flex-direction:column; height:100%; }
@media (max-width:576px){
    table th, table td { font-size:0.85rem; white-space:normal; }
    .btn-sm { font-size:0.75rem; padding:4px 6px; }
}
.toast-container { position: fixed; top: 20px; right: 20px; z-index: 9999; }
</style>
</head>
<body>
<div class="container py-3">

<?php if(!isset($_SESSION['admin'])): ?>
    <!-- LOGIN SCREEN -->
    <div class="card card-login p-3 shadow-sm">
        <h3 class="text-center mb-3">Admin Login</h3>
        <?php if($login_error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($login_error) ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="mb-2"><input type="text" name="admin_user" class="form-control" placeholder="Username" required></div>
            <div class="mb-2"><input type="password" name="admin_pass" class="form-control" placeholder="Password" required></div>
            <button class="btn btn-primary w-100">Login</button>
        </form>
    </div>
<?php else: ?>
    <!-- ADMIN PANEL -->
    <h3 class="text-center mb-3">Viewer & Seller Registrations</h3>

    <div class="filter-links mb-2 text-center">
        <a href="admlogin.php?type=all" class="btn btn-sm btn-outline-primary <?= $type_filter==='all'?'active':'' ?>">All</a>
        <a href="admlogin.php?type=seller" class="btn btn-sm btn-outline-primary <?= $type_filter==='seller'?'active':'' ?>">Sellers</a>
        <a href="admlogin.php?type=viewer" class="btn btn-sm btn-outline-primary <?= $type_filter==='viewer'?'active':'' ?>">Viewers</a>
    </div>

    <div class="table-responsive shadow-sm bg-white rounded p-2 mb-3">
        <table class="table table-bordered mb-0 align-middle">
            <thead class="table-light">
                <tr>
                    <th>Phone</th>
                    <th>Copy Code</th>
                    <th>Seller Expiry</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php while($v = $rows->fetch_assoc()): ?>
                <tr class="summary-row" data-id="<?= $v['id'] ?>">
                    <td class="clickable"><?= htmlspecialchars($v['phone']) ?></td>
                    <td class="text-center">
                        <button class="btn btn-sm btn-secondary btn-block" onclick="copyCode('<?= $v['code'] ?>')">Copy</button>
                        <button class="btn btn-sm btn-success btn-block" onclick="openWhatsApp('<?= $v['phone'] ?>')">WhatsApp</button>
                    </td>
                    <td><?= $v['seller_expiry'] ?? '—' ?></td>
                    <td>
                        <?php if($v['is_seller']): ?>
                            <button class="btn btn-sm btn-warning btn-block toggle-block" data-id="<?= $v['id'] ?>">
                                <?= $v['seller_active'] ? 'Block' : 'Resume' ?>
                            </button>
                        <?php else: ?>
                            — 
                        <?php endif; ?>
                    </td>
                </tr>
                <tr class="details-row d-none" id="details-<?= $v['id'] ?>">
                    <td colspan="4">
                        <form method="post" class="p-2 bg-white rounded shadow-sm card-equal">
                            <input type="hidden" name="edit_id" value="<?= $v['id'] ?>">
                            <div class="mb-1"><strong>Name:</strong>
                                <input type="text" name="name" value="<?= htmlspecialchars($v['name']) ?>" class="form-control form-control-sm">
                            </div>
                            <div class="mb-1"><strong>Phone:</strong>
                                <input type="text" name="phone" value="<?= htmlspecialchars($v['phone']) ?>" class="form-control form-control-sm">
                            </div>
                            <div class="mb-1 form-check">
                                <input type="checkbox" name="is_seller" class="form-check-input" id="sellerCheck-<?= $v['id'] ?>" <?= $v['is_seller']?'checked':'' ?>>
                                <label class="form-check-label" for="sellerCheck-<?= $v['id'] ?>">Seller?</label>
                            </div>
                            <div class="mb-1"><strong>Seller Expiry:</strong>
                                <input type="date" name="seller_expiry" value="<?= $v['seller_expiry'] ?>" class="form-control form-control-sm">
                            </div>
                            <div class="mb-1"><strong>Seller Password:</strong>
                                <input type="text" name="seller_password" value="" class="form-control form-control-sm" placeholder="Leave blank to keep existing">
                            </div>
                            <button class="btn btn-primary btn-sm mt-1">Save Changes</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

<form method="post" class="mb-3">
    <button type="submit" name="delete_expired" class="btn btn-danger w-100"
        onclick="return confirm('Are you sure? This will delete all expired products and images.')">
        Delete All Expired Products
    </button>
</form>

<?php if(isset($success_msg)): ?>
    <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
<?php endif; ?>

<div class="text-center">
    <a href="logout.php" class="btn btn-secondary w-50">Logout</a>
</div>

<?php endif; ?>
</div>

<!-- Toast container -->
<div class="toast-container" id="toast-container"></div>

<script>
// Toggle details
document.querySelectorAll('.summary-row .clickable').forEach(el=>{
    el.addEventListener('click', ()=>{
        let id = el.closest('tr').dataset.id;
        document.querySelectorAll('.details-row').forEach(r=>r.classList.add('d-none'));
        document.getElementById('details-'+id).classList.remove('d-none');
    });
});

// Copy code with toast
function copyCode(code){
    navigator.clipboard.writeText(code)
        .then(()=>showToast("Code copied: " + code))
        .catch(()=>showToast("Copy failed"));
}

// Open WhatsApp
function openWhatsApp(number){
    let phone = number.replace(/\D/g,'');
    window.open("https://wa.me/"+phone,"_blank");
}

// AJAX toggle block/unblock seller
document.querySelectorAll('.toggle-block').forEach(btn=>{
    btn.addEventListener('click', ()=>{
        let id = btn.dataset.id;
        fetch(`admlogin.php?ajax_toggle=${id}`)
            .then(resp => resp.text())
            .then(status=>{
                btn.textContent = status==='1' ? 'Block' : 'Resume';
            });
    });
});

// Toast function
function showToast(msg){
    let toast = document.createElement('div');
    toast.className = 'toast align-items-center text-bg-primary border-0 show mb-2';
    toast.setAttribute('role','alert');
    toast.innerHTML = `<div class="d-flex"><div class="toast-body">${msg}</div>
        <button type="button" class="btn-close btn-close-white me-2 m-auto" onclick="this.parentElement.parentElement.remove()"></button></div>`;
    document.getElementById('toast-container').appendChild(toast);
    setTimeout(()=>toast.remove(),3000);
}
</script>
</body>
</html>
