<?php
// export_codes.php

// === STEP 1: Display file selection form ===
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $directory = __DIR__;
    $fileExtensions = ['php', 'js', 'css', 'html', 'txt']; // allowed file types
    $files = [];

    foreach (scandir($directory) as $file) {
        if (is_file($file)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            if (in_array($ext, $fileExtensions) && $file !== basename(__FILE__)) {
                $files[] = $file;
            }
        }
    }
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Export Code Files</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 40px; background: #f8f9fa; }
            h2 { color: #333; }
            form { background: white; padding: 20px; border-radius: 10px; width: 400px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
            label { display: block; margin: 6px 0; }
            button { margin-top: 10px; padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 6px; cursor: pointer; }
            button:hover { background: #0056b3; }
        </style>
    </head>
    <body>
        <h2>Select files to export</h2>
        <form method="POST">
            <?php foreach ($files as $file): ?>
                <label>
                    <input type="checkbox" name="files[]" value="<?= htmlspecialchars($file) ?>">
                    <?= htmlspecialchars($file) ?>
                </label>
            <?php endforeach; ?>
            <button type="submit">Download TXT</button>
        </form>
    </body>
    </html>
    <?php
    exit;
}

// === STEP 2: Generate and download TXT file ===
if (!empty($_POST['files'])) {
    $selectedFiles = $_POST['files'];
    $directory = __DIR__;

    // Start output buffering for the downloadable content
    header('Content-Type: text/plain');
    header('Content-Disposition: attachment; filename="exported_codes.txt"');

    foreach ($selectedFiles as $file) {
        $filePath = $directory . DIRECTORY_SEPARATOR . $file;
        if (is_file($filePath)) {
            echo "==============================\n";
            echo "### FILE: $file ###\n";
            echo "==============================\n\n";
            echo file_get_contents($filePath);
            echo "\n\n\n";
        }
    }
    exit;
} else {
    echo "<p>No files selected. <a href='export_codes.php'>Go back</a></p>";
}
?>
