<?php
// session_start();
include 'db.php';

// --- AUTO-BASE DETECTION ---
$base_folder = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
function base_url($path = '') {
    global $base_folder;
    return $base_folder . '/' . ltrim($path, '/');
}
// --- END AUTO-BASE DETECTION ---

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = trim($_POST['phone']);
    $key = strtoupper(trim($_POST['key']));

    $stmt = $conn->prepare("SELECT id, name, is_seller, code, verified FROM registration WHERE phone=? AND code=?");
    $stmt->bind_param("ss", $phone, $key);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($user = $res->fetch_assoc()) {
    // Update verified and active expiry
    $expiry = date('Y-m-d H:i:s', strtotime("+3 months"));
    $conn->query("UPDATE registration SET verified=1, created_at=NOW() WHERE id=".$user['id']);

    // Set session
    $_SESSION['user_id']   = $user['id'];
    $_SESSION['user_name'] = $user['name'];
    $_SESSION['is_seller'] = $user['is_seller'];

    // Redirect based on is_seller
    if ($user['is_seller'] == 1) {
        header("Location: " . base_url('mydb'));
    } else {
        header("Location: " . base_url('main'));
    }
    exit;

} else {
    $errors[] = "Invalid phone or key.";
}

    $stmt->close();
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f8f9fa; }
.card { max-width:400px; margin:auto; margin-top:50px; }
</style>
</head>
<body>

<div class="card p-4 shadow-sm">
    <h4 class="mb-3 text-center">Login</h4>

    <?php if($errors): ?>
        <div class="alert alert-danger">
            <?php foreach($errors as $e) echo htmlspecialchars($e)."<br>"; ?>
        </div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-2">
            <input type="text" name="phone" class="form-control" placeholder="Phone Number" required>
        </div>
        <div class="mb-2">
            <input type="text" name="key" class="form-control" placeholder="Enter your Key" required>
        </div>
        <button class="btn btn-primary w-100">Login</button>
    </form>

    <div class="text-center mt-2">
        <a href="<?= base_url('register') ?>">Not registered? Register now |</a>
                <a href="https://wa.me/+971544519576?text=ForgotCode">| Forgot Code</a>

    </div>

</div>

</body>
</html>
