<?php
session_start();
include 'db.php';

// Check login
if (!isset($_SESSION['user_id']) || $_SESSION['is_seller'] != 1) {
    header("Location: login");
    exit;
}

$seller_id = $_SESSION['user_id'];

// -----------------------------------------
// HANDLE SELLER REPLY
// -----------------------------------------
if (isset($_POST['reply_text'], $_POST['response_id'])) {
    $reply_text = trim($_POST['reply_text']);
    $response_id = (int)$_POST['response_id'];

    if ($reply_text !== "") {
        $stmt = $conn->prepare("
            INSERT INTO product_response_replies (response_id, seller_id, reply)
            VALUES (?, ?, ?)
        ");
        $stmt->bind_param("iis", $response_id, $seller_id, $reply_text);
        $stmt->execute();
        $stmt->close();
    }

    header("Location: seller_upload_comments.php");
    exit;
}

// ------------------------------------------------
// Fetch all products of this seller with comment count
// ------------------------------------------------
$products = [];
$sql_products = "
    SELECT 
        p.id, p.name, p.sale_price, p.image_url, p.status,
        (SELECT COUNT(*) FROM product_responses pr WHERE pr.product_id = p.id) AS comment_count
    FROM products p
    WHERE p.seller_id = $seller_id
    ORDER BY p.id DESC
";
$res_p = $conn->query($sql_products);
while ($row = $res_p->fetch_assoc()) {
    $products[] = $row;
}

// ------------------------------------------------
// Fetch all comments for seller’s products
// ------------------------------------------------
$comments = [];
$sql = "
    SELECT pr.id, pr.product_id, pr.viewer_name, pr.viewer_phone, pr.comment, pr.created_at
    FROM product_responses pr
    INNER JOIN products p ON p.id = pr.product_id
    WHERE p.seller_id = $seller_id
    ORDER BY pr.id DESC
";
$res2 = $conn->query($sql);
while ($c = $res2->fetch_assoc()) {
    $pid = $c['product_id'];
    if (!isset($comments[$pid])) $comments[$pid] = [];
    $comments[$pid][] = $c;
}

// ------------------------------------------------
// Fetch replies grouped by response_id
// ------------------------------------------------
$replies = [];
$sql_r = "
    SELECT * FROM product_response_replies
    WHERE seller_id = $seller_id
    ORDER BY id ASC
";
$res_r = $conn->query($sql_r);
while ($r = $res_r->fetch_assoc()) {
    $rid = $r['response_id'];
    if (!isset($replies[$rid])) $replies[$rid] = [];
    $replies[$rid][] = $r;
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Product Comments</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.product-card { background:#fff; border-radius:10px; padding:15px; margin-bottom:20px; box-shadow:0 3px 10px rgba(0,0,0,0.1); }
.product-card img { max-width:150px; max-height:150px; object-fit:cover; border-radius:10px; }
.comment-box { background:#f9f9f9; padding:10px; border-radius:8px; margin-bottom:10px; }
.reply-box { background:#eef7ff; padding:8px; border-radius:6px; margin-top:8px; }
</style>
</head>
<body class="bg-light">

<div class="container py-4">
    <h3 class="mb-4">Customer Comments on Your Products</h3>

    <?php foreach ($products as $p): ?>
        <div class="product-card">
            <div class="d-flex align-items-center mb-3">
                <img src="<?= htmlspecialchars($p['image_url']) ?>" alt="">
                <div class="ms-3">
                    <h5><?= htmlspecialchars($p['name']) ?></h5>
                    <p class="text-muted mb-0">Price: <?= number_format((float)$p['sale_price'], 2) ?></p>
                    <p class="text-muted">Status: <?= $p['status'] == 1 ? 'Active' : 'Inactive' ?></p>
                    <p><strong>Comments: <?= $p['comment_count'] ?></strong></p>
                </div>
            </div>

            <h6>Comments:</h6>

            <?php if (!empty($comments[$p['id']])): ?>
                <?php foreach ($comments[$p['id']] as $c): ?>
                    <div class="comment-box">
                        <div class="comment-name"><?= htmlspecialchars($c['viewer_name']) ?></div>
                        <div class="comment-phone"><?= htmlspecialchars($c['viewer_phone']) ?></div>
                        <div class="comment-text"><?= nl2br(htmlspecialchars($c['comment'])) ?></div>
                        <div class="text-muted small mt-1"><?= $c['created_at'] ?></div>

                        <!-- Existing Replies -->
                        <?php if (!empty($replies[$c['id']])): ?>
                            <?php foreach ($replies[$c['id']] as $r): ?>
                                <div class="reply-box">
                                    <strong>Your Reply:</strong><br>
                                    <?= nl2br(htmlspecialchars($r['reply'])) ?>
                                    <div class="text-muted small mt-1"><?= $r['created_at'] ?></div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>

                        <!-- Seller reply form -->
                        <form method="post" class="mt-2">
                            <input type="hidden" name="response_id" value="<?= $c['id'] ?>">
                            <textarea name="reply_text" class="form-control mb-1" placeholder="Write a reply..." required></textarea>
                            <button class="btn btn-sm btn-primary">Reply</button>
                        </form>

                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-muted">No comments yet.</p>
            <?php endif; ?>

        </div>
    <?php endforeach; ?>
</div>

</body>
</html>
