<?php
// send_message.php
session_start();
include 'db.php';
header('Content-Type: application/json');

if(!isset($_SESSION['user_id'])){
    echo json_encode(['error'=>'Not logged in']); exit;
}

$user_id = (int)$_SESSION['user_id'];
$message = trim($_POST['message'] ?? '');
$product_id = (int)($_POST['product_id'] ?? 0);
$receiver_id = (int)($_POST['receiver_id'] ?? 0);
$conversation_id = (int)($_POST['conversation_id'] ?? 0);

if ($message === '') { echo json_encode(['error'=>'Message cannot be empty']); exit; }
if ($product_id <= 0 || $receiver_id <= 0) { echo json_encode(['error'=>'Missing product or receiver']); exit; }

// Normalize participants
$buyer = $user_id;
$seller = $receiver_id;

// If conversation_id not provided, try to find existing conversation for same product & participants
if ($conversation_id === 0) {
    $sql = "
        SELECT conversation_id
        FROM product_conversations
        WHERE product_id = ?
          AND (
               (sender_id = ? AND receiver_id = ?)
               OR
               (sender_id = ? AND receiver_id = ?)
          )
          AND conversation_id > 0
        ORDER BY message_id ASC
        LIMIT 1
    ";
    $chk = $conn->prepare($sql);
    $chk->bind_param("iiiii", $product_id, $buyer, $seller, $seller, $buyer);
    $chk->execute();
    $res = $chk->get_result();
    if ($row = $res->fetch_assoc()) {
        $conversation_id = (int)$row['conversation_id'];
    }
    $chk->close();
}

if ($conversation_id > 0) {
    $stmt = $conn->prepare("INSERT INTO product_conversations (conversation_id,product_id,sender_id,receiver_id,message,created_at) VALUES (?,?,?,?,?,NOW())");
    $stmt->bind_param("iiiis", $conversation_id, $product_id, $user_id, $receiver_id, $message);
    if ($stmt->execute()) {
        echo json_encode(['success'=>true,'conversation_id'=>$conversation_id]);
        $stmt->close();
        exit;
    } else {
        echo json_encode(['error'=>'Database error: '.$conn->error]);
        exit;
    }
}

// No existing conversation: create starter message and set conversation_id = message_id
$stmt = $conn->prepare("INSERT INTO product_conversations (product_id,sender_id,receiver_id,message,created_at) VALUES (?,?,?,?,NOW())");
$stmt->bind_param("iiis", $product_id, $user_id, $receiver_id, $message);
if ($stmt->execute()) {
    $newMessageId = (int)$stmt->insert_id;
    $stmt->close();

    $upd = $conn->prepare("UPDATE product_conversations SET conversation_id = ? WHERE message_id = ?");
    $upd->bind_param("ii", $newMessageId, $newMessageId);
    $upd->execute();
    $upd->close();

    echo json_encode(['success'=>true,'conversation_id'=>$newMessageId]);
    exit;
} else {
    echo json_encode(['error'=>'Database error: '.$conn->error]);
    exit;
}
